%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Generate training and verification data for Example 6.8
% Created by John Harlim
% Last edited: March 26, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all, clear all

% Triad model

L = [0 1; 0 -1];
B = [.5 -.5];
S = [1 1/4;1/4 1];
Shalf= sqrtm(S);
sigma = 1;
d = 1/2;

dt = 0.01;
sdt = sqrt(dt);
T = 100000;

% Apply Euler-Maruyama
x = zeros(2,T+1);

% avoid transient
for j=1:1000
    x(1,j+1) = x(1,j)+dt*B(1)*x(1,j)*x(2,j); 
    x(2,j+1) = x(2,j)+dt*B(2)*x(1,j)*x(1,j);     
    x(:,j+1) = x(:,j+1) + (L-S*d)*x(:,j)*dt + sigma*Shalf*sdt*randn(2,1);
end

x(:,1) = x(:,1001);

for j=1:T
     x(1,j+1) = x(1,j)+dt*B(1)*x(1,j)*x(2,j); 
    x(2,j+1) = x(2,j)+dt*B(2)*x(1,j)*x(1,j); 
    
    x(:,j+1) = x(:,j+1) + (L-S*d)*x(:,j)*dt + sigma*Shalf*sdt*randn(2,1);
end


varx = var(x,[],2);
x2 = x - repmat(mean(x,2),1,T+1);

xc = zeros(2,T+1);

for j=1:2
    temp = xcorr(x2(j,:),'coeff');
    xc(j,:) = temp(T+1:end);
    figure(1)
    subplot(2,1,j),plot(x(j,:))
    
    figure(2)
    subplot(2,1,j),plot([0:dt:dt*T],xc(j,:))
    xlim([0 10])
end

save truth2d x dt;

%figure(1)
%orient tall
%print -depsc -r100 truth2.eps

%figure(2)
%orient tall
%print -depsc -r100 corfun2.eps